FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:${THISDIR}/files:"

SRC_URI += "file://usb_modules.cfg"
SRC_URI += "file://disable_thermal.cfg"

inherit kernel-module-split
DEPENDS += "ncurses"

do_configure_prepend() {
    if [ "${@bb.utils.contains('DISTRO_FEATURES', 'enable_usb_rfs_mount', 'true', 'false', d)}" = "false" ]; then
        sed -i 's/CONFIG_USB_STORAGE=y/CONFIG_USB_STORAGE=m/g' ${WORKDIR}/usb_modules.cfg
    fi
}
do_install_append() {
    install -d ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers
    install -d ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/hid/usbhid
    install -d ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/serial
    install -d ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/mon
    install -m 0644 ${B}/drivers/hid/usbhid/usbhid.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/hid/usbhid
    install -m 0644 ${B}/drivers/usb/serial/belkin_sa.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/serial
    install -m 0644 ${B}/drivers/usb/serial/pl2303.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/serial
    install -m 0644 ${B}/drivers/usb/serial/usbserial.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/serial
    install -m 0644 ${B}/drivers/usb/mon/usbmon.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/mon
    if [ "${@bb.utils.contains('DISTRO_FEATURES', 'enable_usb_rfs_mount', 'true', 'false', d)}" = "false" ]; then
        install -d ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/storage
        install -m 0644 ${B}/drivers/usb/storage/usb-storage.ko ${D}/lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/storage
    fi
}

module_conf_usbhid = "blacklist usbhid"
module_conf_belkin_sa = "blacklist belkin_sa"
module_conf_pl2303 = "blacklist pl2303"
module_conf_usbserial = "blacklist usbserial"
module_conf_usbmon = "blacklist usbmon"

KERNEL_MODULE_PROBECONF += "usbhid belkin_sa pl2303 usbserial usbmon"
